/*
Veidotājs: Roberts Blite
Mērķis: Lietotāja ievades validācija reģistrācijas formā.
Apraksts: Skripts pārbauda, vai ievadītais e-pasts atbilst derīgam domēnam,
          un automātiski atjaunina telefona numuru ar izvēlēto valsts kodu.
*/

// Derīgo e-pasta domēnu saraksts validācijai
const validDomains = [
    "gmail.com",
    "yahoo.com",
    "hotmail.com",
    "outlook.com",
    "inbox.lv",
    "mail.lv"
];

// Iegūst e-pasta lauku un kļūdas paziņojuma elementu
const emailField = document.getElementById("email");
const emailError = document.getElementById("email-error");

// Iegūst valsts kodu un telefona numura lauku
const countryCodeField = document.getElementById("country-code");
const phoneNumberField = document.getElementById("phone-number");

// E-pasta validācija - pārbauda, vai e-pasta domēns ir atļauts
emailField.addEventListener("blur", () => {
    const emailValue = emailField.value; // Iegūst ievadīto e-pastu
    const domain = emailValue.split("@")[1]; // Atdala domēna daļu

    if (domain && validDomains.includes(domain)) {
        emailError.textContent = ""; // Notīra kļūdas paziņojumu
        emailField.style.borderColor = "#ddd"; // Atgriež sākotnējo apmali
    } else {
        emailError.textContent = "Lūdzu, ievadiet derīgu e-pasta adresi!"; // Parāda kļūdu
        emailField.style.borderColor = "red"; // Izceļ lauku ar sarkanu apmali
    }
});

// Telefona numura atjaunināšana ar kodu zonu
countryCodeField.addEventListener("change", () => {
    phoneNumberField.value = countryCodeField.value + " "; // Pievieno izvēlēto valsts kodu
});
